/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.View;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Billboard
extends Behavior {
    public static final int ROTATE_ABOUT_AXIS = 0;
    public static final int ROTATE_ABOUT_POINT = 1;
    WakeupOnElapsedFrames wakeupFrame = new WakeupOnElapsedFrames(0, true);
    int mode = 0;
    Vector3f axis = new Vector3f(0.0f, 1.0f, 0.0f);
    Point3f rotationPoint = new Point3f(0.0f, 0.0f, 1.0f);
    private Vector3d nAxis = new Vector3d(0.0, 1.0, 0.0);
    TransformGroup tg = null;
    private Point3d viewPosition = new Point3d();
    private Point3d yUpPoint = new Point3d();
    private Vector3d eyeVec = new Vector3d();
    private Vector3d yUp = new Vector3d();
    private Vector3d zAxis = new Vector3d();
    private Vector3d yAxis = new Vector3d();
    private Vector3d vector = new Vector3d();
    private AxisAngle4d aa = new AxisAngle4d();
    static final double EPSILON = 1.0E-6;

    public Billboard() {
        this.nAxis.x = 0.0;
        this.nAxis.y = 1.0;
        this.nAxis.z = 0.0;
    }

    public Billboard(TransformGroup transformGroup) {
        this.tg = transformGroup;
        this.nAxis.x = 0.0;
        this.nAxis.y = 1.0;
        this.nAxis.z = 0.0;
    }

    public Billboard(TransformGroup transformGroup, int n2, Vector3f vector3f) {
        this.tg = transformGroup;
        this.mode = n2;
        this.axis.set(vector3f);
        double d2 = 1.0 / Math.sqrt(vector3f.x * vector3f.x + vector3f.y * vector3f.y + vector3f.z * vector3f.z);
        this.nAxis.x = (double)vector3f.x * d2;
        this.nAxis.y = (double)vector3f.y * d2;
        this.nAxis.z = (double)vector3f.z * d2;
    }

    public Billboard(TransformGroup transformGroup, int n2, Point3f point3f) {
        this.tg = transformGroup;
        this.mode = n2;
        this.rotationPoint.set(point3f);
    }

    public void setAlignmentMode(int n2) {
        this.mode = n2;
    }

    public int getAlignmentMode() {
        return this.mode;
    }

    public void setAlignmentAxis(Vector3f vector3f) {
        this.axis.set(vector3f);
        double d2 = 1.0 / Math.sqrt(vector3f.x * vector3f.x + vector3f.y * vector3f.y + vector3f.z * vector3f.z);
        this.nAxis.x = (double)vector3f.x * d2;
        this.nAxis.y = (double)vector3f.y * d2;
        this.nAxis.z = (double)vector3f.z * d2;
    }

    public void setAlignmentAxis(float f2, float f3, float f4) {
        this.axis.set(f2, f3, f4);
        this.axis.set(this.axis);
        double d2 = 1.0 / Math.sqrt(this.axis.x * this.axis.x + this.axis.y * this.axis.y + this.axis.z * this.axis.z);
        this.nAxis.x = (double)this.axis.x * d2;
        this.nAxis.y = (double)this.axis.y * d2;
        this.nAxis.z = (double)this.axis.z * d2;
    }

    public void getAlignmentAxis(Vector3f vector3f) {
        vector3f.set(this.axis);
    }

    public void setRotationPoint(Point3f point3f) {
        this.rotationPoint.set(point3f);
    }

    public void setRotationPoint(float f2, float f3, float f4) {
        this.rotationPoint.set(f2, f3, f4);
    }

    public void getRotationPoint(Point3f point3f) {
        point3f.set(this.rotationPoint);
    }

    public void setTarget(TransformGroup transformGroup) {
        this.tg = transformGroup;
    }

    public TransformGroup getTarget() {
        return this.tg;
    }

    public void initialize() {
        this.wakeupOn(this.wakeupFrame);
    }

    public void processStimulus(Enumeration enumeration) {
        double d2 = 0.0;
        if (this.tg == null) {
            this.wakeupOn(this.wakeupFrame);
            return;
        }
        View view = this.getView();
        if (view == null) {
            this.wakeupOn(this.wakeupFrame);
            return;
        }
        Canvas3D canvas3D = view.getCanvas3D(0);
        Transform3D transform3D = new Transform3D();
        Transform3D transform3D2 = new Transform3D();
        Transform3D transform3D3 = new Transform3D();
        ((TransformGroupRetained)this.tg.retained).getTransform(transform3D3);
        if (this.mode == 0) {
            canvas3D.getCenterEyeInImagePlate(this.viewPosition);
            canvas3D.getImagePlateToVworld(transform3D);
            transform3D.transform(this.viewPosition);
            ((NodeRetained)this.tg.retained).getLocalToVworld(transform3D);
            transform3D.invert();
            transform3D.transform(this.viewPosition);
            this.eyeVec.set(this.viewPosition);
            this.eyeVec.normalize();
            boolean bl = this.projectToPlane(this.eyeVec, this.nAxis);
            if (bl) {
                this.zAxis.x = 0.0;
                this.zAxis.y = 0.0;
                this.zAxis.z = 1.0;
                bl = this.projectToPlane(this.zAxis, this.nAxis);
            }
            ((TransformGroupRetained)this.tg.retained).getTransform(transform3D);
            if (bl) {
                this.vector.cross(this.eyeVec, this.zAxis);
                double d3 = this.vector.dot(this.nAxis) > 0.0 ? 1.0 : -1.0;
                double d4 = this.eyeVec.dot(this.zAxis);
                if (d4 > 1.0) {
                    d4 = 1.0;
                } else if (d4 < -1.0) {
                    d4 = -1.0;
                }
                d2 = d3 * Math.acos(d4);
                this.aa.x = this.nAxis.x;
                this.aa.y = this.nAxis.y;
                this.aa.z = this.nAxis.z;
                this.aa.angle = -d2;
                transform3D2.set(this.aa);
                if (!transform3D3.epsilonEquals(transform3D2, 1.0E-6)) {
                    this.tg.setTransform(transform3D2);
                }
            } else {
                transform3D2.setIdentity();
                if (!transform3D3.epsilonEquals(transform3D2, 1.0E-6)) {
                    this.tg.setTransform(transform3D2);
                }
            }
        } else {
            double d5;
            Transform3D transform3D4 = new Transform3D();
            canvas3D.getCenterEyeInImagePlate(this.viewPosition);
            this.yUpPoint.set(this.viewPosition);
            this.yUpPoint.y += 0.01;
            canvas3D.getImagePlateToVworld(transform3D);
            transform3D.transform(this.viewPosition);
            transform3D.transform(this.yUpPoint);
            ((NodeRetained)this.tg.retained).getLocalToVworld(transform3D);
            transform3D.invert();
            transform3D.transform(this.viewPosition);
            transform3D.transform(this.yUpPoint);
            this.eyeVec.set(this.viewPosition);
            this.eyeVec.normalize();
            this.yUp.set(this.yUpPoint);
            this.yUp.sub(this.viewPosition);
            this.yUp.normalize();
            this.zAxis.x = 0.0;
            this.zAxis.y = 0.0;
            this.zAxis.z = 1.0;
            this.vector.cross(this.eyeVec, this.zAxis);
            double d6 = this.vector.length();
            if (d6 > 1.0E-4) {
                d5 = this.eyeVec.dot(this.zAxis);
                if (d5 > 1.0) {
                    d5 = 1.0;
                } else if (d5 < -1.0) {
                    d5 = -1.0;
                }
                d2 = Math.acos(d5);
                this.aa.x = this.vector.x;
                this.aa.y = this.vector.y;
                this.aa.z = this.vector.z;
                this.aa.angle = -d2;
                transform3D4.set(this.aa);
            } else {
                transform3D4.set(1.0);
            }
            this.yAxis.x = 0.0;
            this.yAxis.y = 1.0;
            this.yAxis.z = 0.0;
            transform3D4.transform(this.yAxis);
            boolean bl = this.projectToPlane(this.yAxis, this.eyeVec);
            if (bl) {
                bl = this.projectToPlane(this.yUp, this.eyeVec);
            }
            ((TransformGroupRetained)this.tg.retained).getTransform(transform3D);
            if (bl) {
                d5 = this.yUp.dot(this.yAxis);
                if (d5 > 1.0) {
                    d5 = 1.0;
                } else if (d5 < -1.0) {
                    d5 = -1.0;
                }
                d2 = Math.acos(d5);
                this.vector.cross(this.yUp, this.yAxis);
                if (this.eyeVec.dot(this.vector) < 0.0) {
                    d2 *= -1.0;
                }
                this.aa.x = this.eyeVec.x;
                this.aa.y = this.eyeVec.y;
                this.aa.z = this.eyeVec.z;
                this.aa.angle = -d2;
                transform3D.set(this.aa);
                this.vector.x = this.rotationPoint.x;
                this.vector.y = this.rotationPoint.y;
                this.vector.z = this.rotationPoint.z;
                transform3D2.set(this.vector);
                transform3D2.mul(transform3D);
                transform3D2.mul(transform3D4);
                this.vector.scale(-1.0);
                transform3D.set(this.vector);
                transform3D2.mul(transform3D);
                if (!transform3D3.epsilonEquals(transform3D2, 1.0E-6)) {
                    this.tg.setTransform(transform3D2);
                }
            } else {
                transform3D2.setIdentity();
                if (!transform3D3.epsilonEquals(transform3D2, 1.0E-6)) {
                    this.tg.setTransform(transform3D2);
                }
            }
        }
        this.wakeupOn(this.wakeupFrame);
    }

    private boolean projectToPlane(Vector3d vector3d, Vector3d vector3d2) {
        double d2 = vector3d2.dot(vector3d);
        vector3d.x -= vector3d2.x * d2;
        vector3d.y -= vector3d2.y * d2;
        vector3d.z -= vector3d2.z * d2;
        double d3 = vector3d.length();
        if (d3 < 1.0E-6) {
            return false;
        }
        vector3d.scale(1.0 / d3);
        return true;
    }

    public Node cloneNode(boolean bl) {
        Billboard billboard = new Billboard();
        billboard.duplicateNode(this, bl);
        return billboard;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        Billboard billboard = (Billboard)node;
        this.setAlignmentMode(billboard.getAlignmentMode());
        Vector3f vector3f = new Vector3f();
        billboard.getAlignmentAxis(vector3f);
        this.setAlignmentAxis(vector3f);
        Point3f point3f = new Point3f();
        billboard.getRotationPoint(point3f);
        this.setRotationPoint(point3f);
        this.setTarget(billboard.getTarget());
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        super.updateNodeReferences(nodeReferenceTable);
        TransformGroup transformGroup = this.getTarget();
        if (transformGroup != null) {
            this.setTarget((TransformGroup)nodeReferenceTable.getNewObjectReference(transformGroup));
        }
    }
}

